import yfinance as yf
import pandas as pd

tickers = ['MSFT', 'AAPL', 'GOOG', 'SAP', 'IBM', 'ORCL']
start_date = '2015-01-01'  # 10 years back from 2025-01-01
end_date = '2025-09-06'

# Download all tickers together -> MultiIndex columns (Field, Ticker)
data = yf.download(tickers, start=start_date, end=end_date, progress=False)

# Select only the Close level and reshape to long format (one row per day/ticker)
# This avoids the duplicated header row issue entirely.
close = data['Close']                     # columns = tickers
final_df = close.stack(dropna=False)      # index -> (Date, Ticker)
final_df = final_df.reset_index()         # make Date/Ticker columns
final_df.columns = ['Date', 'Ticker', 'Close']  # clean column names

# Write to CSV with a single header row, no index column
final_df.to_csv('stocks.csv', index=False)
